/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.prop.PropPanel;
import cds.tools.Astrodate;
import cds.tools.Util;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrameTimeToolbox
extends JFrame {
    private static final boolean CONVERT = false;
    protected Aladin aladin;
    private static final String[] LABELS = new String[]{"ISO time", "JD", "MJD", "Julian years", "Besselian years"};
    private static final int[] CODE = new int[]{15, 13, 14, 16, 19};
    private static final int NB = LABELS.length;
    private static final String[] SYS = new String[]{"TCB", "UTC", "TAI", "TT", "UT1", "TDB"};
    private JTextField[] fromTime = new JTextField[NB];
    private JTextField[] toTime = new JTextField[NB];
    private JComboBox<String> fromCombo;
    private JComboBox<String> toCombo;
    private double jdtime = Double.NaN;

    protected FrameTimeToolbox(Aladin aladin) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.setTitle(Aladin.chaine.getString("TIMETOOL"));
        this.enableEvents(64L);
        Util.setCloseShortcut(this, true, aladin);
        this.setLocation(Aladin.computeLocation(this));
        this.getContentPane().add((Component)this.createPanel(), "Center");
        this.getContentPane().add((Component)this.getPanelBottom(), "South");
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.aladin.frameTimeTool = null;
        }
        super.processWindowEvent(e);
    }

    private JPanel createPanel() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.setLayout(g);
        for (int i = 0; i < NB; ++i) {
            JLabel label = new JLabel(LABELS[i] + ": ");
            label.setFont(label.getFont().deriveFont(1));
            JPanel p3 = new JPanel(new GridLayout(1, 2));
            this.fromTime[i] = new JTextField(15);
            final int index = i;
            this.fromTime[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameTimeToolbox.this.modify(index);
                }
            });
            p3.add(this.fromTime[i]);
            PropPanel.addCouple(p, label, p3, g, c);
        }
        return p;
    }

    protected JPanel getPanelBottom() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1));
        JButton b = new JButton(Aladin.chaine.getString("CLEAR"));
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameTimeToolbox.this.reset();
            }
        });
        b = new JButton(Aladin.chaine.getString("UPCLOSE"));
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameTimeToolbox.this.aladin.frameTimeTool = null;
                FrameTimeToolbox.this.dispose();
            }
        });
        return p;
    }

    protected void modify() {
        this.modify(0);
    }

    protected void modify(int from) {
        try {
            String s = this.fromTime[from].getText();
            this.jdtime = s.trim().length() == 0 ? Double.NaN : Astrodate.parseTime(s, CODE[from]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resume();
    }

    private void resume() {
        this.resume(true);
    }

    private void resume(boolean flagLog) {
        for (int i = 0; i < NB; ++i) {
            if (Double.isNaN(this.jdtime)) {
                this.fromTime[i].setText("");
                continue;
            }
            try {
                String s = Astrodate.editTime(this.jdtime, CODE[i]);
                this.fromTime[i].setText(s);
                continue;
            }
            catch (Exception e) {
                this.fromTime[i].setText("");
            }
        }
        if (flagLog) {
            this.aladin.glu.log("TimeToolbox", "");
        }
    }

    private void reset() {
        this.jdtime = Double.NaN;
        this.resume(false);
    }
}

